/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_10; import java.util.Vector; 
import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class CollectionDemo {

	/** Whlen Sie hier, ob Sie den Test lokal oder via DIIOP durchfhren mchten */
	private static final boolean localOrRemote = true;
	
	private static final String LOCALPASSWORD = "geheim";
	private static final String REMOTEPASSWORD = "geheim";
	private static final String REMOTEUSER = "Thomas Ekert/DJBUCH";
	
	public static void main(String[] args){
		Database db = null; Session session = null;
		try {
			if (localOrRemote) {
				NotesThread.sinitThread();
				session = NotesFactory.createSession((String) null, (String) null, LOCALPASSWORD);
			} else {
				session = NotesFactory.createSession("www.djbuch.de", REMOTEUSER, REMOTEPASSWORD);
			}
			db = session.getDatabase("", "djbuch/djbuch.nsf");
			DemoTools.startup(db, 20);
			int count1 = dumpDatabase(db);
			int count2 = dumpView (db, "V_lookup_k6", null);
			int count3 = dumpView(db, "V_lookup_k6", "FIELD F_category=Wombats");
			int count4 = updateView(db, "V_lookup_k6",
					"FIELD F_category=Wombats", "F_newField", "value", false);
			int count5 = updateView(db, "V_lookup_k6",
					"FIELD F_category=Wombats", "F_newField", "value", true);
			int count6 = deleteFromView(db, "V_lookup_k6", "FIELD F_category=Wombats", false);
			System.out.println(count1 + " / " + count2 + " / " + count3 + " / "
					+ count4 + " / " + count5 + " / " + count6);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println ((e instanceof NotesException?"id = "+((NotesException)e).id:""));
		} finally {
			GC.recycle(db); GC.recycle(session);
			if (localOrRemote) NotesThread.stermThread();
		}
	}
	
	private static final int dumpDatabase (Database db) throws NotesException{
		DocumentCollection dc = null; Document doc = null, nextDoc = null;
		int count = 1, size=0;
		try {
			dc = db.getAllDocuments();
			if (dc==null) return -1;
			size=dc.getCount();
			doc = dc.getFirstDocument();
			while (doc != null) {
				System.out.println ("Dokument " + count++ + " / " + size);
				dumpDoc (doc);
				nextDoc = dc.getNextDocument();
				GC.recycle(doc);
				doc = nextDoc;
			}
		} finally {
			GC.recycle (doc); GC.recycle (nextDoc); GC.recycle(dc);
		}
		return size;
	}
	
	private static final int dumpView (Database db, String viewName, String query)
		throws NotesException {
		View view = null; Document doc = null, nextDoc = null;
		int count = 1, size=0;
		try {
			view = db.getView(viewName);
			if (view==null) return -1;
			if (query!=null) view.FTSearch(query);
			size=view.getAllEntries().getCount();
			doc = view.getFirstDocument();
			while (doc != null) {
				System.out.println ("Dokument " + count++ + " / " + size);
				dumpDoc (doc);
				nextDoc = view.getNextDocument(doc);
				GC.recycle(doc);
				doc = nextDoc;
			}
		} finally {
			GC.recycle (doc); GC.recycle (nextDoc); GC.recycle(view);
		}
		return size;
	}
	
	private static final int deleteFromView (Database db, String viewName, String query, boolean allInOne)
		throws NotesException {
		View view = null; Document doc = null, nextDoc = null;
		int count = 1, size=0;
		try {
			view = db.getView(viewName);
			if (view==null) return -1;
			if (query!=null) view.FTSearch(query);			
			size=view.getAllEntries().getCount();
			if (allInOne) {
				view.getAllEntries().removeAll(true);
			}
			doc = view.getFirstDocument();
			while (doc != null) {
				System.out.println ("Dokument " + count++ + " / " + size);
				nextDoc = view.getNextDocument(doc);
				boolean someExtraCondition = doc.hasItem ("Item_0");
				if (someExtraCondition) {
					doc.remove(true);
				}
				GC.recycle(doc);
				doc = nextDoc;
			}
		} finally {
			GC.recycle (doc); GC.recycle (nextDoc); GC.recycle(view);
		}
		return size;
	}
	
	private static final int updateView(Database db, String viewName,
			String query, String name, String value, boolean allInOne) throws NotesException {
		View view = null; ViewEntryCollection vec = null;
		Document doc = null, nextDoc = null; int count = 1, size=0;
		try {
			view = db.getView(viewName);
			if (view==null) return -1;
			if (query!=null) view.FTSearch(query);
			vec = view.getAllEntries();
			size=vec.getCount();
			if (allInOne) {
				vec.stampAll(name,value);
			} else {
				boolean remindAutoUpdateStatus = view.isAutoUpdate();
				view.setAutoUpdate(false);
				doc = view.getFirstDocument();
				while (doc != null) {
					System.out.println ("Dokument " + count++ + " / " + size);
					doc.replaceItemValue(name, "individuell " + count + " / " + value);
					nextDoc = view.getNextDocument(doc);
					GC.recycle(doc);
					doc = nextDoc;
				}
				view.setAutoUpdate(remindAutoUpdateStatus);
				view.refresh();
			}
		} finally {
			GC.recycle (doc); GC.recycle (nextDoc);
			GC.recycle (vec); GC.recycle(view);
		}
		return size;
	}
	
	private static final void dumpDoc (Document doc) throws NotesException {
		Item item = null;
		try {
			Vector allItems = doc.getItems();
			for (int i = 0; i<allItems.size();i++) {
				item = (Item)allItems.elementAt(i);
				if (item.getType()==Item.TEXT) {
					System.out.println (item.getName() + " = " + item.getValueString());
				}
				if (localOrRemote) GC.recycle(item);
			}
		} finally {
			if (localOrRemote) GC.recycle(item);
		}
	}

}
